@extends('inventory.layout') 
@section('title', 'Categories')
@section('content')
 @push('head')
  <style>
    .error{
      color: red;
    }
  </style>
  @endpush
    <!-- push external head elements to head --> 
    <div class="container-fluid">
      <div class="page-header">
            <div class="row align-items-end">
                <div class="col-lg-8">
                    <div class="page-header-title">
                        <i class="ik ik-list bg-blue"></i>
                        <div class="d-inline">
                            <h5>{{ isset($parentname->name) ? $parentname->name:'' }} @if(isset($parentname)) > @endif {{ isset($parentcategory->name) ? $parentcategory->name:'' }} {{ __('Sub Categories')}}</h5>
                            
                        </div>
                    </div>
                </div>
                <div class="col-lg-4">
                    <nav class="breadcrumb-container" aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="{{url('dashboard')}}"><i class="ik ik-home"></i></a>
                            </li>
                            <li class="breadcrumb-item">
                                <a href="#">{{ __('Categories')}}</a>
                            </li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>
        <div class="row">
            <!-- start message area-->
            @include('include.message')
            <!-- end message area-->
            <div class="col-md-12">
                <div class="mb-2 clearfix">
                    <a class="btn pt-0 pl-0 d-md-none d-lg-none" data-toggle="collapse" href="#displayOptions" role="button" aria-expanded="true" aria-controls="displayOptions">
                        {{ __('Display Options')}}
                        <i class="ik ik-chevron-down align-middle"></i>
                    </a>
                    <div class="collapse d-md-block display-options" id="displayOptions">
                        
                        <div class="d-block d-md-inline-block">
                            
                            <div class="search-sm d-inline-block float-md-left mr-1 mb-1 align-top">
                                <form action="{{route('categories.search')}}" method="get">
                                    <input type="text" class="form-control" placeholder="Search.." name="name" required>
                                    <button type="submit" class="btn btn-icon"><i class="ik ik-search"></i></button>
                                    <button type="button" id="adv_wrap_toggler" class="adv-btn ik ik-chevron-down dropdown-toggle" data-toggle="dropdown" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"></button>
                                    <div class="adv-search-wrap dropdown-menu dropdown-menu-right" aria-labelledby="adv_wrap_toggler">
                                        <div class="form-group">
                                            <input type="text" class="form-control" placeholder="Category Title">
                                        </div>
                                        
                                        <button class="btn btn-theme">{{ __('Search')}}</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <div class="float-md-right">

                    
                            <a href="{{route('categories.index')}}"><button class="btn btn-outline-primary btn-rounded-20">
                                Back 
                            </button>
                            </a>
                        </div>
                    </div>
                </div>
                <div class="separator mb-20"></div>

                <div class="row layout-wrap" id="layout-wrap">
                    
                    @include('include.message')
                    <!-- end message area-->
                    <div class="col-md-12">
                        <div class="card p-3">
                            <div class="card-header"><h3> {{ isset($parentcategory->name) ? $parentcategory->name:'' }} {{ __('Sub Categories')}}</h3></div>
                            <div class="card-body">
                                <table id="user_table" class="table">
                                    <thead>
                                        <tr>
                                           <th>{{ __('Image')}}</th>
                                            <th>{{ __('Name')}}</th>

                                            <th>{{ __('Slug')}}</th>
                                            <th>{{ __('Action')}}</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($category as $cat)
                                          <tr>
                                            <td>
                                              @if(isset($cat->image)) 
                                                <img src="{{ url('images/upload/category/'.$cat['image'])}}" alt="" class="img-fluid img-20">
                                                @else
                                                <img src="{{ url('img/category.png')}}" alt="" id="output_image"  style="width: 20%; height: 20px;">
                                                @endif
                                            </td>
                                            <td>{{ isset($cat->name) ? $cat->name :'' }}</td>
                                            <td>{{ isset($cat->slug) ? $cat->slug :'' }}</td>
                                            
                                            <td>
                                              <a href="{{ route('categories.show', $cat['id']) }}"><i class="ik ik-list"></i></a>
                                              &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                              <a href="javascript:;"  class="detailbycatid"  data-id="{{ isset($cat->id) ? $cat->id:'' }}" data-url="{{url('categorydetail', $cat['id']) }}"><i class="fa fa-eye text-green"></i></a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                             <a href="javascript:;"  class="editbycatid"  data-id="{{ isset($cat->id) ? $cat->id:'' }}" data-url="{{ route('categories.edit', $cat['id']) }}"><i class="ik ik-edit-2 f-16 mr-15 text-green"></i></a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                            <a href="javascript:;" class="deletebyid" data-id="{{ isset($cat->id) ? $cat->id:'' }}"  data-url="{{route('categorydelete',$cat['id'])}}"><i class="ik ik-trash-2 f-16 text-red"></i></a></td>
                                          </tr>
                                        @endforeach
                                     
                                      </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>  
                </div>
                
                
            </div>
        </div>
    </div>
    <!-- category edit modal -->
    <div class="modal fade edit-layout-modal pr-0 " id="categoryView" tabindex="-1" role="dialog" aria-labelledby="categoryViewLabel" aria-hidden="true" style="display: none;">
        <div class="modal-dialog w-300" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="categoryViewLabel">{{ __('Edit Category')}}</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <form class="forms-sample" method="POST" action="{{ route('updatecategory') }}" enctype= multipart/form-data >
                     @csrf   
                        
                            
                  <div class="modal-body">
                    <span id="publicurl" data-value="{{url('/')}}"></span>
                    <span id="imgurl" data-imgurl="{{url('images/upload/category')}}"></span>
                    <span id="deleteurl"  data-dlturl="{{url('deleteimg')}}" ></span>
                      <div class="form-group">
                          <input  type="hidden" class="form-control catid" name="id" >
                          <label class="d-block">Category Image</label>
                          <div class="appndimg"></div>
                          <input type="file" name="image" class="form-control">

                      </div>
                      <div class="form-group">
                          <label class="d-block">Category Title</label>
                          <input type="text" name="name" class="form-control catname" placeholder="Enter Category Title" value="">
                      </div>
                      <div class="form-group">
                          <label class="d-block">Slug</label>
                          <input type="text" class="form-control catslug" id="slug" name="slug" placeholder="Enter Slug" value="">
                      </div>
                      <div class="form-group">
                      <label for="d-block">Type</label>
                      <input type="text" class="form-control selecttype cattype" id="type" name="type" placeholder="Enter Type" value="Item">
                      </div>
                      <div class="form-group appendparent">
                          
                      </div>
                      <div class="form-group">
                         <button type="submit" class="btn btn-primary form-control-right updatecategory" >{{ __('Update')}}</button>
                      </div>
                  </div>
              </form>
            </div>
        </div>
    </div>
    {{--<div class="modal fade edit-layout-modal pr-0 " id="categoryView" tabindex="-1" role="dialog" aria-labelledby="categoryViewLabel" aria-hidden="true" style="display: none;">
        <div class="modal-dialog w-300" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="categoryViewLabel">{{ __('Edit Category')}}</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                
                <form class="forms-sample" method="GET" action="{{ route('subcategory') }}" enctype= multipart/form-data >
                  <div class="modal-body">
                    <span id="publicurl" data-value="{{url('/')}}"></span>
                     <span id="imgurl" data-imgurl="{{url('images/upload/category')}}"></span>
                    <span id="deleteurl"  data-dlturl="{{url('deleteimg')}}" ></span>
                      <div class="form-group">
                          <input  type="hidden" class="form-control catid" name="id" >
                          <label class="d-block">Category Image</label>
                          <div class="appndimg"></div>
                          <input type="file" name="file" class="form-control">

                      </div>
                      <div class="form-group">
                          <label class="d-block">Category Title</label>
                          <input type="text" name="name" class="form-control catname" placeholder="Enter Category Title" value="">
                      </div>
                      <div class="form-group">
                          <label class="d-block">Slug</label>
                          <input type="text" class="form-control catslug" id="slug" name="slug" placeholder="Enter Slug" value="">
                      </div>
                      <div class="form-group">
                      <label for="d-block">Type</label>
                      <input type="text" class="form-control selecttype" id="type" name="type" placeholder="Enter Type" value="Item">
                      </div>
                      <div class="form-group appendparent">
                          
                      </div>
                      <div class="form-group">
                         <button type="submit" class="btn btn-primary form-control-right updatecategory">{{ __('Update')}}</button>
                      </div>
                  </div>
                </form>
            </div>
        </div>
    </div>--}}

    <!-- detail model -->
    <div class="modal fade edit-layout-modal pr-0 show" id="productView" tabindex="-1" role="dialog" aria-labelledby="productViewLabel" style="padding-right: 17px; display: none;" aria-modal="true">
      <div class="modal-dialog" role="document">
          <div class="modal-content">
              <div class="modal-header">
                  <h5 class="modal-title catname" id="productViewLabel"></h5>
                  <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
              </div>
              <div class="modal-body">
                <span id="imgurl" data-imgurl="{{url('images/upload/category')}}"></span>
                  <div class="row">
                      <div class="col-4 appndimg">
                          
                      </div>
                  </div>
            
                          
              </div>
          </div>
      </div>

    </div>
    

@push('script')
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.2/jquery.validate.min.js"></script>

 <script src="{{ url('js/jstree.bundle.js')}}" type="text/javascript"></script>
<script src="{{ url('js/treeview.js')}}"></script>
<script src="{{ url('js/selectparentcategory.js')}}"></script> 
<script src="{{ url('js/global.js')}}"></script>

 @endpush
 @endsection